import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Center from './Center';

export default {
    title: 'Avia/Center',
    component: Center,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Center style={{width: 480, height: 320, background: 'pink'}}>
        &apos;Ohana&apos; means &apos;family&apos;.
    </Center>
);

export const DisableHorizontal: TStorybookFunctionComponent = () => (
    <Center
        style={{width: 480, height: 320, background: 'pink'}}
        horizontal={false}
    >
        &apos;Family&apos; means &apos;no one gets left behind&apos;.
    </Center>
);
DisableHorizontal.parameters = {
    info: {
        comment:
            'Можно отключить выравнивание по горизонтали указав пропсу `horizontal={false}`',
    },
};

export const DisableVertical: TStorybookFunctionComponent = () => (
    <Center
        style={{width: 480, height: 320, background: 'pink'}}
        vertical={false}
    >
        But if you want to leave, you can. I&apos;ll remember you though.
    </Center>
);
DisableVertical.parameters = {
    info: {
        comment:
            'Можно отключить выравнивание по верткали указав пропсу `vertical={false}`',
    },
};
