import {FC, memo, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {
    EFareFamilyAvailability,
    IFFChangingCarriageTermRule,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {getChangingCarriageText} from './utilities/getChangingCarriageText';

import IncludedIcon from 'icons/24/Included';
import NotIncludedIcon from 'icons/24/NotIncluded';
import Text from 'components/Text/Text';
import PaidReturnIcon from 'icons/24/PaidReturn';

import cx from './ChangingCarriageInfo.scss';

export interface IChangingCarriageInfoProps
    extends IWithClassName,
        IWithQaAttributes {
    changingCarriage: IFFChangingCarriageTermRule;
}

const ChangingCarriageInfo: FC<IChangingCarriageInfoProps> = props => {
    const {className, changingCarriage} = props;

    const text = getChangingCarriageText(changingCarriage);
    const type = changingCarriage.availability;
    const IconLeft = useMemo(() => {
        if (type === EFareFamilyAvailability.free) {
            return IncludedIcon;
        }

        if (type === EFareFamilyAvailability.charge) {
            return PaidReturnIcon;
        }

        return NotIncludedIcon;
    }, [type]);

    return (
        <span
            className={cx('content', className)}
            {...prepareQaAttributes({
                parent: props,
                current: 'changingCarriageInfo',
            })}
        >
            <IconLeft
                className={cx('icon', {
                    icon_included: type === EFareFamilyAvailability.free,
                })}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'changingCarriageIcon',
                })}
            />
            <Text
                size="m"
                className={cx('text', {
                    text_included: type === EFareFamilyAvailability.free,
                })}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'changingCarriageText',
                })}
            >
                {text}
            </Text>
        </span>
    );
};

export default memo(ChangingCarriageInfo);
