import insertJSXIntoKey from '@yandex-data-ui/i18n-ts/client/insertJSXIntoKey';
import {ReactNode} from 'react';

import {
    EFareFamilyAvailability,
    IFFChangingCarriageTermRule,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

import * as i18nBlock from 'i18n/avia-search-tariffs';

import Price from 'components/Price/Price';

const CHANGING_CARRIAGE_TEXT_MAP = {
    [EFareFamilyAvailability.notAvailable]: i18nBlock.withoutChangingCarriage(),
    [EFareFamilyAvailability.charge]: i18nBlock.chargedChangingCarriage(),
    [EFareFamilyAvailability.free]: i18nBlock.includedChangingCarriage(),
};

export function getChangingCarriageText(
    changingCarriage: IFFChangingCarriageTermRule | null,
): ReactNode {
    if (!changingCarriage || !changingCarriage.availability) {
        return i18nBlock.withoutInfoChangingCarriage();
    }

    if (changingCarriage.charge?.value) {
        return insertJSXIntoKey(i18nBlock.chargedChangingCarriageWithPrice)({
            price: (
                <Price withConversion={false} {...changingCarriage.charge} />
            ),
        });
    }

    return CHANGING_CARRIAGE_TEXT_MAP[changingCarriage.availability];
}
