import React, {FunctionComponent} from 'react';
import {useSelector} from 'react-redux';

import {TInlineSearchRequest} from 'projects/avia/components/Dynamics/types/TInlineSearchRequest';
import {IDynamicsCalendarDay} from 'projects/avia/components/Dynamics/types/IDynamicsDay';

import {aviaContextSelector} from 'selectors/avia/context/aviaContextSelector';

import getMonthFromDateRobot from 'utilities/dateUtils/getMonthFromDateRobot';
import getYearFromDateRobot from 'utilities/dateUtils/getYearFromDateRobot';

import Month from './components/Month/Month';

import cx from './AviaDynamicsCalendar.scss';

interface IAviaDynamicsCalendarProps {
    days: IDynamicsCalendarDay[];
    inlineSearchRequest: TInlineSearchRequest;
    isCurrentDayHightlighted: boolean;

    onLinkClick?: () => void;
}

const AviaDynamicsCalendar: FunctionComponent<IAviaDynamicsCalendarProps> = ({
    days,
    inlineSearchRequest,
    isCurrentDayHightlighted,

    onLinkClick,
}) => {
    const aviaContext = useSelector(aviaContextSelector);

    if (!days.length) {
        return null;
    }

    // Разбиваем дни по месяцам
    const daysByMonth = days.reduce((res, day) => {
        const year = getYearFromDateRobot(day.dateForward.date);
        const monthNumber = getMonthFromDateRobot(day.dateForward.date);

        const monthKey = `${year}-${monthNumber}`;

        let month = res.get(monthKey);

        if (!month) {
            month = [];
            res.set(monthKey, month);
        }

        month.push(day);

        return res;
    }, new Map<string, IDynamicsCalendarDay[]>());

    return (
        <>
            {[...daysByMonth.entries()].map(([monthKey, monthDays]) => (
                <Month
                    key={monthKey}
                    className={cx('month')}
                    aviaContext={aviaContext}
                    days={monthDays}
                    inlineSearchRequest={inlineSearchRequest}
                    isCurrentDayHightlighted={isCurrentDayHightlighted}
                    onLinkClick={onLinkClick}
                />
            ))}
        </>
    );
};

export default React.memo(AviaDynamicsCalendar);
