import React from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/avia-AviaDynamics';

import Box from 'components/Box/Box';
import Button from 'components/Button/Button';

interface IProps extends IWithClassName {
    onRetry: () => void;
}

const AviaDynamicsCalendarError: React.FC<IProps> = props => {
    return (
        <Box className={props.className} between="4">
            <div>{i18nBlock.dynamicsDashUnknownDashErrorDashText()}</div>
            <div>
                <Button onClick={props.onRetry}>
                    {i18nBlock.dynamicsDashRetryDashButtonDashText()}
                </Button>
            </div>
        </Box>
    );
};

export default AviaDynamicsCalendarError;
