import IPrice from 'utilities/currency/PriceInterface';
import {PriceComparator} from 'utilities/currency/compare';
import {priceDivide} from 'utilities/currency/priceMath';

interface IDynamicsDayHeightProps {
    price: Nullable<IPrice>;
    minPrice?: IPrice;
    maxPrice?: IPrice;
    priceComparator: PriceComparator;
}

export function getDynamicsDayHeight({
    price,
    minPrice,
    maxPrice,
    priceComparator,
}: IDynamicsDayHeightProps): number {
    if (
        !price ||
        !maxPrice ||
        priceComparator.isEqualPrice(minPrice, maxPrice)
    ) {
        return 100;
    }

    return Math.round(priceDivide(price, maxPrice).value * 100);
}
