import React, {useCallback} from 'react';
import {useDispatch} from 'react-redux';

import EAviaDynamicActionLogActionName from 'server/loggers/avia/AviaActionLog/types/EAviaDynamicActionLogActionName';

import {loggerActions} from 'reducers/avia/aviaLogging/actions';

import Modal from 'components/Modal/Modal';
import DynamicsCommonContainer from 'projects/avia/components/Dynamics/Chart/DynamicsCommonContainer/DynamicsCommonContainer';

import {useAviaUiContext} from 'projects/avia/context/AviaUiContext';

export function DynamicsModal(): React.ReactElement {
    const {dynamicsIsVisible, toggleDynamics} = useAviaUiContext();
    const dispatch = useDispatch();

    const handlerOnClose = useCallback(() => {
        if (dynamicsIsVisible) {
            dispatch(
                loggerActions.logDynamicAction({
                    name: EAviaDynamicActionLogActionName.DYNAMIC_CLOSE,
                }),
            );
        }

        toggleDynamics();
    }, [dispatch, dynamicsIsVisible, toggleDynamics]);

    return (
        <Modal
            hasCloseButton
            autoclosable
            isVisible={dynamicsIsVisible}
            onClose={handlerOnClose}
            preventBodyScroll
        >
            {
                /**
                 * При закрытии модалки компонент не знает, что он скрыт снаружи.
                 * Если в этот момент был открыт попап над столбиком, то после закрытия модалки
                 * он останется висеть над контентом страницы.
                 * Здесь компонент перерысовывается при открытии модалки, чтобы не костылять ему какую-то логику изнутри.
                 */
                dynamicsIsVisible && (
                    <DynamicsCommonContainer
                        onClose={handlerOnClose}
                        newDesktopDynamic
                    />
                )
            }
        </Modal>
    );
}
