import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import EAviaDynamicActionLogActionName from 'server/loggers/avia/AviaActionLog/types/EAviaDynamicActionLogActionName';

import {loggerActions} from 'reducers/avia/aviaLogging/actions';

import getWeekPricesInfo from 'selectors/avia/weekPrices/aviaWeekPricesInfo';

import {DynamicsButton} from 'projects/avia/components/Dynamics/DynamicsButton/DynamicsButton';

import {useAviaUiContext} from 'projects/avia/context/AviaUiContext';

export function SerpDynamics(): React.ReactElement {
    const {toggleDynamics, dynamicsIsVisible} = useAviaUiContext();
    const dispatch = useDispatch();
    const {priceType, priceDiff} = useSelector(getWeekPricesInfo);

    const handlerClick = useCallback(() => {
        if (!dynamicsIsVisible) {
            dispatch(
                loggerActions.logDynamicAction({
                    name: EAviaDynamicActionLogActionName.DYNAMIC_OPEN,
                }),
            );
        }

        toggleDynamics();
    }, [dispatch, dynamicsIsVisible, toggleDynamics]);

    return (
        <DynamicsButton
            priceType={priceType}
            price={priceDiff}
            onClick={handlerClick}
        />
    );
}
