import {connect} from 'react-redux';

import EAviaDynamicActionLogActionName from 'server/loggers/avia/AviaActionLog/types/EAviaDynamicActionLogActionName';

import {StoreInterface} from 'reducers/storeTypes';
import {changeBackwardDate} from 'reducers/avia/aviaPriceIndex/dynamics/actions';
import {CustomDispatch} from 'reducers/trains/customDispatch';
import {loggerActions} from 'reducers/avia/aviaLogging/actions';

import {aviaDynamicsPricesSearchFormSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesSearchFormSelector';
import experimentsSelector from 'selectors/common/experimentsSelector';

import {DynamicsDeltaButton} from './DynamicsDeltaButton';

function mapStateToProps(state: StoreInterface) {
    const searchForm = aviaDynamicsPricesSearchFormSelector(state);
    const experiments = experimentsSelector(state);

    return {
        searchForm,
        experiments,
    };
}

function mapDispatchToProps(dispatch: CustomDispatch) {
    return {
        changeBackwardDate: (dateBackward: string) =>
            dispatch(changeBackwardDate(dateBackward)),
        onClickDate: () =>
            dispatch(
                loggerActions.logDynamicAction({
                    name: EAviaDynamicActionLogActionName.DYNAMIC_DATE_SEARCH_CLICK,
                }),
            ),
    };
}

export default connect(
    mapStateToProps,
    mapDispatchToProps,
)(DynamicsDeltaButton);
