import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import EAviaDynamicActionLogActionName from 'server/loggers/avia/AviaActionLog/types/EAviaDynamicActionLogActionName';

import {loggerActions as aviaLoggingActions} from 'reducers/avia/aviaLogging/actions';

import aviaDynamicsPricesCurrentRequestParamsSelector from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesCurrentRequestParamsSelector';
import {aviaDynamicsPricesFinalPriceSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesFinalPriceSelector';
import {aviaDynamicsPricesRequestParamsSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesRequestParamsSelector';
import {aviaDynamicsPricesStatusSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesSelectors';

import {useBoolean} from 'utilities/hooks/useBoolean';
import {useToggle} from 'utilities/hooks/useToggle';

import BottomSheet from 'components/BottomSheet/BottomSheet';
import SearchDynamic from 'projects/avia/components/Dynamics/SearchDynamic/SearchDynamic';

interface ISearchDynamicLandingWrapperProps extends IWithClassName {
    isVisible: boolean;
    onLinkClick: () => void;
}

const SearchDynamicLandingWrapper: React.FC<ISearchDynamicLandingWrapperProps> =
    ({className, onLinkClick, isVisible}) => {
        const dispatch = useDispatch();
        const {
            value: isFullCalendar,
            setTrue: openFullCalendar,
            setFalse: closeFullCalendar,
        } = useBoolean(false);
        const pricesFromState = useSelector(
            aviaDynamicsPricesFinalPriceSelector,
        );
        const searchFormAndFilters = useSelector(
            aviaDynamicsPricesRequestParamsSelector,
        );

        const currentRequestParams = useSelector(
            aviaDynamicsPricesCurrentRequestParamsSelector,
        );

        const status = useSelector(aviaDynamicsPricesStatusSelector);

        const [, toggleDynamics] = useToggle(false);

        const onCloseDynamics = useCallback(() => {
            toggleDynamics();
            dispatch(
                aviaLoggingActions.logDynamicAction({
                    name: EAviaDynamicActionLogActionName.DYNAMIC_CLOSE,
                }),
            );
            closeFullCalendar();
        }, [dispatch, toggleDynamics, closeFullCalendar]);

        return (
            <>
                <SearchDynamic
                    className={className}
                    isFullCalendarForce={isFullCalendar}
                    isVisible={isVisible}
                    pricesFromState={pricesFromState}
                    searchFormAndFilters={searchFormAndFilters}
                    currentRequestParams={currentRequestParams}
                    status={status}
                    onLinkClick={onLinkClick}
                    isCurrentDayHightlighted={false}
                    onClickFullCalendar={openFullCalendar}
                />
                {isFullCalendar && (
                    <BottomSheet
                        isOpened={isFullCalendar}
                        onClose={onCloseDynamics}
                    >
                        <SearchDynamic
                            isVisible={isVisible}
                            pricesFromState={pricesFromState}
                            searchFormAndFilters={searchFormAndFilters}
                            currentRequestParams={currentRequestParams}
                            status={status}
                            onLinkClick={onLinkClick}
                            isCurrentDayHightlighted={false}
                            isFullCalendarForce={isFullCalendar}
                        />
                    </BottomSheet>
                )}
            </>
        );
    };

export default React.memo(SearchDynamicLandingWrapper);
