import React from 'react';
import {useSelector} from 'react-redux';

import {aviaDynamicsPricesStatusSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesSelectors';
import {aviaDynamicsPricesFinalPriceSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesFinalPriceSelector';
import {aviaDynamicsPricesRequestParamsSelector} from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesRequestParamsSelector';
import aviaDynamicsPricesCurrentRequestParamsSelector from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesCurrentRequestParamsSelector';

import SearchDynamic from './SearchDynamic';

interface ISearchDynamicSearchWrapperProps {
    isVisible: boolean;

    wrapperClassName?: string;
    hideMoreButton?: boolean;
    onLinkClick?: () => void;
}

const SearchDynamicSearchWrapper: React.FC<ISearchDynamicSearchWrapperProps> =
    ({
        isVisible,

        wrapperClassName,
        hideMoreButton,
        onLinkClick,
    }) => {
        const pricesFromState = useSelector(
            aviaDynamicsPricesFinalPriceSelector,
        );
        const searchFormAndFilters = useSelector(
            aviaDynamicsPricesRequestParamsSelector,
        );

        const currentRequestParams = useSelector(
            aviaDynamicsPricesCurrentRequestParamsSelector,
        );

        const status = useSelector(aviaDynamicsPricesStatusSelector);

        return (
            <SearchDynamic
                wrapperClassName={wrapperClassName}
                hideMoreButton={hideMoreButton}
                onLinkClick={onLinkClick}
                isVisible={isVisible}
                pricesFromState={pricesFromState}
                searchFormAndFilters={searchFormAndFilters}
                currentRequestParams={currentRequestParams}
                status={status}
            />
        );
    };

export default React.memo(SearchDynamicSearchWrapper);
