import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import AviaDynamicsCalendarFilters from 'projects/avia/components/Dynamics/Calendar/AviaDynamicsCalendarFilters/AviaDynamicsCalendarFilters';
import DynamicsDeltaButtonConnected from 'projects/avia/components/Dynamics/DynamicsDeltaButton/DynamicsDeltaButtonConnected';

interface ICalendarToolbar extends IWithClassName {}

const CalendarToolbar: FunctionComponent<ICalendarToolbar> = ({className}) => {
    return (
        <Flex
            className={className}
            flexDirection="column"
            between="3"
            x={0}
            y={0}
        >
            <DynamicsDeltaButtonConnected isMobile />
            <AviaDynamicsCalendarFilters />
        </Flex>
    );
};

export default CalendarToolbar;
