import React from 'react';

import {IStandaloneDynamicsFilterType} from 'projects/avia/components/Dynamics/StandaloneFilters/type';

import {
    EAviaSearchTransferFilter,
    IAviaSearchTimeFilter,
} from 'reducers/avia/search/results/filters/reducer';

import {isEnabled} from 'utilities/flags/flags';

import * as keyset from 'i18n/avia-search';

import Box from 'components/Box/Box';
import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import {AviaTimeFilterPopup} from 'projects/avia/components/AviaSearchResultsTimeFilter/AviaTimeFilterPopup';
import {AviaTransferFilterPopup} from 'projects/avia/components/AviaSearchResultsTransferFilter/AviaTransferFilterPopup/AviaTransferFilterPopup';
import {AviaSearchResultsBaggageFilter} from 'projects/avia/components/AviaSearchResultsBaggageFilter/AviaSearchResultsBaggageFilter';
import {AviaSearchResultsNoTransferFilter} from 'projects/avia/components/AviaSearchResultsNoTransferFilter/AviaSearchResultsNoTransferFilter';

const DesktopStandaloneFilters: React.FC<IStandaloneDynamicsFilterType> = ({
    time,
    transfer,
    baggage,
    handleTimeChange,
    handleBaggageChange,
    handleTransfersChange,
    handleNoTransfersChange,
}) => {
    return (
        <Box between="2" inline>
            <AviaSearchResultsNoTransferFilter
                checked={isEnabled(
                    transfer.value,
                    EAviaSearchTransferFilter.NO_TRANSFERS,
                )}
                onChange={handleNoTransfersChange}
            />

            <AviaSearchResultsBaggageFilter
                onChange={handleBaggageChange}
                checked={baggage.enabled}
            />

            <DropdownFilter
                checked={transfer.value !== 0}
                label={keyset.filterDotTransfersDashPlaceholder()}
            >
                <AviaTransferFilterPopup
                    hideRange
                    hideTransferAirports
                    transfersValue={transfer.value}
                    onChangeTransfers={handleTransfersChange}
                />
            </DropdownFilter>

            <DropdownFilter
                checked={time.departure !== 0 || time.arrival !== 0}
                label={keyset.filterDotTimeDotTitle()}
            >
                <Box inline nowrap between={8}>
                    <AviaTimeFilterPopup
                        segmentIdx={0}
                        disabled={
                            {arrival: 0, departure: 0} as IAviaSearchTimeFilter
                        }
                        value={
                            time ||
                            ({
                                arrival: 0,
                                departure: 0,
                            } as IAviaSearchTimeFilter)
                        }
                        onChange={handleTimeChange}
                    />
                </Box>
            </DropdownFilter>
        </Box>
    );
};

export default DesktopStandaloneFilters;
