import React from 'react';
import moment from 'moment';

import TDateRobot from 'types/common/date/TDateRobot';
import {IWithClassName} from 'types/withClassName';

import {HUMAN_SHORT, HUMAN_WEEKDAY_SHORT} from 'utilities/dateUtils/formats';

import cx from './Day.scss';

export interface IDayProps extends IWithClassName {
    date: TDateRobot;
    isHoliday: boolean;
}

const Day: React.FC<IDayProps> = ({
    date,
    isHoliday,

    className,
}) => {
    const dateMoment = moment(date);

    return (
        <div
            className={cx('root', className, {
                root_isHoliday: isHoliday,
            })}
        >
            <span className={cx('dayOfWeek')}>
                {dateMoment.format(HUMAN_WEEKDAY_SHORT)}
            </span>

            <span className={cx('date')}>{dateMoment.format(HUMAN_SHORT)}</span>
        </div>
    );
};

export default React.memo(Day);
