import React from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import {inlineSearchRequest as inlineSearchRequestAction} from 'reducers/avia/aviaPriceIndex/dynamics/inlineSearchRequest';

import {aviaContextDatesSelector} from 'selectors/avia/context/aviaContextDatesSelector';

import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

import OneWayTable from 'projects/avia/components/Dynamics/Table/OneWayTable/OneWayTable';
import RoundTripTable from 'projects/avia/components/Dynamics/Table/RoundTripTable/RoundTripTable';

export interface IDynamicTableProps extends IWithClassName {
    onLinkClick: () => void | undefined; // Колбэк на клик по ссылке на поиск
}

const DynamicTable: React.FC<IDynamicTableProps> = ({
    onLinkClick,
    className,
}) => {
    const dispatch = useDispatch();

    const searchDates = useSelector(aviaContextDatesSelector);

    const inlineSearchRequest = useImmutableCallback(
        (dateForward: string, dateBackward: string | null) =>
            dispatch(inlineSearchRequestAction(dateForward, dateBackward)),
    );

    if (!searchDates) {
        return null;
    }

    const {when: searchWhen, returnDate: searchReturnDate} = searchDates;

    return (
        <div className={className}>
            {searchReturnDate ? (
                <RoundTripTable
                    inlineSearchRequest={inlineSearchRequest}
                    onLinkClick={onLinkClick}
                    searchWhen={searchWhen}
                    searchReturnDate={searchReturnDate}
                />
            ) : (
                <OneWayTable
                    inlineSearchRequest={inlineSearchRequest}
                    onLinkClick={onLinkClick}
                />
            )}
        </div>
    );
};

export default React.memo(DynamicTable);
