import React from 'react';

import * as i18nBlock from 'i18n/avia-AviaDynamics';

import Button from 'components/Button/Button';

import cx from './Error.scss';

export interface IErrorProps {
    type: 'oneWay' | 'roundTrip';
    loadData: () => void;
}

const Error: React.FC<IErrorProps> = ({type, loadData}) => {
    return (
        <div
            className={cx('root', {
                root_type_oneWay: type === 'oneWay',
                root_type_roundTrip: type === 'roundTrip',
            })}
        >
            <div className={cx('text')}>
                {i18nBlock.dynamicsDashUnknownDashErrorDashText()}
            </div>
            <Button onClick={loadData} className={cx('retryButton')}>
                {i18nBlock.dynamicsDashRetryDashButtonDashText()}
            </Button>
        </div>
    );
};

export default React.memo(Error);
