import React from 'react';

import * as i18nBlock from 'i18n/avia-AviaDynamics';

import Spinner from 'components/Spinner/Spinner';

import cx from './Loading.scss';

export interface ILoadingProps {
    type: 'oneWay' | 'roundTrip';
}

const Loading: React.FC<ILoadingProps> = ({type}) => {
    return (
        <div
            className={cx('root', {
                root_type_oneWay: type === 'oneWay',
                root_type_roundTrip: type === 'roundTrip',
            })}
        >
            <Spinner size="s" />

            <div className={cx('text')}>
                {i18nBlock.dynamicsDashSpinnerDashText()}
            </div>
        </div>
    );
};

export default React.memo(Loading);
