// Значения из первого блока должны быть синхронизированы с ./const.scss
// Ширина блока
export const WIDTH_DAY = 106;
// Высота блока
export const HEIGHT_DAY = 48;
// Расстояние между блоками
export const GAP_DAY = 8;

// Ширина блока вместе с отступом
export const FULL_WIDTH_DAY = WIDTH_DAY + GAP_DAY;
// Высота блока вместе с отступом
export const FULL_HEIGHT_DAY = HEIGHT_DAY + GAP_DAY;
// Количество дополнительных дней слева/справа/снизу/сверху от текущей даты.
// Нужно для того, чтобы при прокрутке, следующие/предыдущие дни уже имелись на странице
export const DATES_RANGE_ADDITIONAL = 2;

// Количество дней слева/справа от текущей даты, которые видны пользователю для таблицы "туда"
export const ONE_WAY_DATES_RANGE = 4;
// Ширина области просмотра для пользователя
export const ONE_WAY_WIDTH = ONE_WAY_DATES_RANGE * 2 * FULL_WIDTH_DAY - GAP_DAY;

// Количество дней слева/справа от текущей даты, которые видны пользователю для таблицы "туда-обратно"
export const ROUND_TRIP_DATES_RANGE_HORIZONTAL = 2;
// Количество дней сверху/снизу от текущей даты, которые видны пользователю для таблицы "туда-обратно"
export const ROUND_TRIP_DATES_RANGE_VERTICAL = 2;
