import {IAviaPriceIndexPrice} from 'server/api/AviaPriceIndexApi/types/IAviaPriceIndexPrice';
import IRoundTripDate from 'types/common/date/IRoundTripDate';
import ICalendarDate from 'types/common/date/ICalendarDate';

import {EPriceHintType} from 'projects/avia/components/Dynamics/utilities/getPriceHintType';

export interface IDynamicsDay extends IRoundTripDate {
    status: EDynamicsDayStatus;
    progress: number;
    price: Nullable<IAviaPriceIndexPrice>;
}

export interface IDynamicsCalendarDay extends IDynamicsDay {
    type: EPriceHintType;
    url: string;
}

export interface IDynamicsTableCalendarDay extends IDynamicsCalendarDay {
    dateBackward: ICalendarDate;
}

export enum EDynamicsDayStatus {
    HAS_DATA = 'has-data',
    NO_DATA = 'no-data', // Нет рейсов
    SHOULD_SEARCH = 'should-search', // Данных нет или они не точные, нужно запросить
    SEARCHING = 'searching',
    WAS_ERROR = 'was-error',
}

export enum EDynamicsDaysShown {
    week = 7,
    month = 32,
}

export enum EDynamicsDaysMode {
    WEEK = 'week',
    MONTH = 'month',
}
