import TDateRobot from 'types/common/date/TDateRobot';

import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {IDayWithPrice} from './getPriceHintInfo';

/**
 * Добавляет к переданному массиву дат цены
 */
export default function buildPriceDaysByDates(
    dates: TDateRobot[],
    prices: TDynamicsDaysInfo,
): IDayWithPrice[] {
    return dates.map(date => ({
        date,
        price: prices[date]?.price || undefined,
    }));
}
