import {Moment} from 'moment';

import {DATE, HUMAN_SHORT} from 'utilities/dateUtils/formats';
import {CHAR_DASH} from 'utilities/strings/charCodes';

export function dynamicsDateFormat(
    forwardDateMoment: Moment,
    backwardDateMoment: Nullable<Moment>,
): string {
    if (backwardDateMoment) {
        const sameMonth = forwardDateMoment.isSame(backwardDateMoment, 'month');
        const forwardDateFormat = sameMonth ? DATE : HUMAN_SHORT;
        const backwardDateFormat = HUMAN_SHORT;

        return `${forwardDateMoment.format(
            forwardDateFormat,
        )} ${CHAR_DASH} ${backwardDateMoment.format(backwardDateFormat)}`;
    }

    return forwardDateMoment.format(HUMAN_SHORT);
}
