import moment from 'moment';

import TDateRobot from 'types/common/date/TDateRobot';

import getDateRobotFromMoment from 'utilities/dateUtils/getDateRobotFromMoment';

/**
 * Количество дней (+/-) от переданного дня, для которых будет рассчитываться диапазон
 */
export const RANGE_DATES = 3;

/**
 * В контексте динамики неделя - это отрезок из RANGE_DATES*2+1 дней (+-RANGE_DATES дня от переданной даты),
 * но не раньше текущего дня. Если дата раньше текущего дня, то она добавляется с правой границы отрезка.
 */
export default function dynamicsWeekDates(
    when: TDateRobot,
    rangeDates?: number,
): TDateRobot[] {
    const beforeDaysCount = RANGE_DATES;
    const weekDays = rangeDates ? rangeDates - 1 : RANGE_DATES * 2; // 7 c нулем

    const whenMoment = moment.utc(when).startOf('day');
    const nowMoment = moment.utc().startOf('day');

    const mainDate = moment.max(whenMoment, nowMoment);
    const diffToNow = mainDate.diff(nowMoment, 'days');

    const maxLeftOffset =
        diffToNow >= beforeDaysCount ? beforeDaysCount : diffToNow;

    const leftDate = mainDate.subtract(maxLeftOffset, 'days');
    const dates = [getDateRobotFromMoment(leftDate)];

    for (let i = 0; i < weekDays; i++) {
        dates.push(getDateRobotFromMoment(leftDate.add(1, 'days')));
    }

    return dates;
}
