import moment from 'moment';

import TDateRobot from 'types/common/date/TDateRobot';

import dynamicsWeekDates from 'projects/avia/components/Dynamics/utilities/dynamicsWeekDates';
import getDateRobotFromMoment from 'utilities/dateUtils/getDateRobotFromMoment';

export type TInterval = {
    startDate: TDateRobot;
    endDate: TDateRobot;
};

/**
 * Возвращает интервал дат для динамики на неделю
 */
export function getAviaDynamicsCalendarWeekDates(when: TDateRobot): TInterval {
    const dates = dynamicsWeekDates(when);

    return {
        startDate: dates[0],
        endDate: dates[dates.length - 1],
    };
}

/**
 * Возвращает интервал дат для полного календаря динамики цен
 */
export function getAviaDynamicsCalendarYearDates(): TInterval {
    const now = moment.utc(); // По-хорошему тут должна быть сегодняшняя дата в таймзоне аэропорта вылета, но ее похоже просто нет

    return {
        startDate: getDateRobotFromMoment(now),
        endDate: getDateRobotFromMoment(now.add(1, 'year').subtract(1, 'day')),
    };
}

export function getAviaDynamicsCalendarDates(
    when: TDateRobot,
    isFullCalendar: boolean = false,
): TInterval {
    if (isFullCalendar) {
        return getAviaDynamicsCalendarYearDates();
    }

    return getAviaDynamicsCalendarWeekDates(when);
}
