import moment from 'moment';

import {EDynamicsDaysShown} from 'projects/avia/components/Dynamics/types/IDynamicsDay';
import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

import {TInterval} from 'projects/avia/components/Dynamics/utilities/getAviaDynamicsCalendarDates';
import getDateRobotFromMoment from 'utilities/dateUtils/getDateRobotFromMoment';
import isDateRobot from 'utilities/dateUtils/isDateRobot';

/**
 * Возвращает интервал дат для десктопной динамики
 *
 * Для первого запроса берем условные 3 месяца(3 группы видимых дней
 * в месячном режиме отображения динамики - 96 дней)
 */
const DAYS_FOR_REQUEST = EDynamicsDaysShown.month * 3;

export function getAviaDynamicsDesktopInterval(
    searchForm: IAviaParams,
): TInterval | null {
    const {when} = searchForm;

    if (!isDateRobot(when)) {
        return null;
    }

    const today = moment.utc().startOf('day');
    const forwardDate = moment.utc(when).startOf('day');

    const diff = forwardDate.diff(today, 'days');

    const daysForStart = Math.min(diff, 32);
    const daysForEnd = DAYS_FOR_REQUEST - daysForStart;

    const startDate = moment.utc(forwardDate).subtract(daysForStart, 'days');
    const endDate = moment.utc(forwardDate).add(daysForEnd, 'days');

    return {
        startDate: getDateRobotFromMoment(startDate),
        endDate: getDateRobotFromMoment(endDate),
    };
}
