import {IDynamicsDay} from 'projects/avia/components/Dynamics/types/IDynamicsDay';
import ICalendarDate from 'types/common/date/ICalendarDate';

import {
    createFakePrice,
    TDynamicTableDaysInfo,
} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import getKeyForTablePrice from 'projects/avia/lib/dynamic/getKeyForTablePrice';

interface IDateForGetDynamicDaysForTable {
    dateForward: ICalendarDate;
    dateBackward: ICalendarDate;
}

/**
 * Обогащает массив дат путешествий для отображения в виде таблицы ценами из priceIndex
 */
export default function getDynamicDayForTable<
    T extends IDateForGetDynamicDaysForTable,
>(date: T, prices: TDynamicTableDaysInfo): T & IDynamicsDay {
    const key = getKeyForTablePrice(
        date.dateForward.date,
        date.dateBackward.date,
    );
    const priceInfo = prices[key] || createFakePrice();

    return {
        ...date,
        ...priceInfo,
    };
}
