import {IDynamicsDay} from 'projects/avia/components/Dynamics/types/IDynamicsDay';
import IRoundTripDate from 'types/common/date/IRoundTripDate';

import {
    createFakePrice,
    TDynamicsDaysInfo,
} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

/**
 * Обогащает массив дат путешествий ценами из priceIndex
 */
export default function getDynamicDays<T extends IRoundTripDate>(
    dates: T[],
    prices: TDynamicsDaysInfo,
): (T & IDynamicsDay)[] {
    return dates.map(date => {
        const priceInfo = prices[date.dateForward.date] || createFakePrice();

        return {
            ...date,
            ...priceInfo,
        };
    });
}
