import {IAviaPriceIndexPrice} from 'server/api/AviaPriceIndexApi/types/IAviaPriceIndexPrice';

import IPrice from 'utilities/currency/PriceInterface';

export enum EPriceHintType {
    EXPENSIVE = 'expensive',
    ACCEPTABLE = 'acceptable',
    EMPTY = 'empty',
    MINIMAL = 'minimal',
}

// пока что захардкодил валюту, надо научиться нормально их получать
export const usd = 64;

const DEFAULT_USD_LIMIT = 30;

/**
 * @see https://st.yandex-team.ru/RASPTICKETS-11479
 * @see https://wiki.yandex-team.ru/avia/docs/changedatetips/
 */
export function getPriceHintType({
    currentPrice,
    weekMinPrice,
    allWithPrices,
    limit = DEFAULT_USD_LIMIT,
}: {
    currentPrice: IPrice;
    weekMinPrice: IAviaPriceIndexPrice;
    allWithPrices: boolean;
    limit?: number;
}): EPriceHintType {
    const currentPriceValue = currentPrice.value;
    const weekPriceValue = weekMinPrice.value;

    const acceptableLimit = Math.min(
        limit * usd,
        Math.round(currentPriceValue * 0.1),
    );

    const diff = Math.round(currentPriceValue - weekPriceValue);

    if (allWithPrices) {
        const absDiff = Math.abs(diff);
        const isAcceptable = absDiff <= acceptableLimit;

        if (isAcceptable) {
            return EPriceHintType.ACCEPTABLE;
        }

        const isCurrentPriceCheapest = diff < 0;

        return isCurrentPriceCheapest
            ? EPriceHintType.MINIMAL
            : EPriceHintType.EXPENSIVE;
    }

    const isAcceptable = diff <= acceptableLimit;

    return isAcceptable ? EPriceHintType.EMPTY : EPriceHintType.EXPENSIVE;
}
