import ITableDynamicCalendarDate from 'projects/avia/components/Dynamics/types/ITableDynamicCalendarDate';
import TDateRobot from 'types/common/date/TDateRobot';

import {TDynamicTableDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {EPriceHintType} from 'projects/avia/components/Dynamics/utilities/getPriceHintType';
import {
    getDynamicsCalendarDayType,
    IPriceDay,
} from 'projects/avia/components/Dynamics/utilities/getDynamicsCalendarDayType';
import getKeyForTablePrice from 'projects/avia/lib/dynamic/getKeyForTablePrice';

const TABLE_RANGE_DATES = 2;

export interface IGetPriceHintTypeForDayOfDynamicTable {
    prices: TDynamicTableDaysInfo;
    dateForward: ITableDynamicCalendarDate;
    dateBackward: ITableDynamicCalendarDate;
    datesForward: ITableDynamicCalendarDate[];
    datesBackward: ITableDynamicCalendarDate[];
}

/**
 * Возвращает тип цены для дня в таблице динамики цен.
 *
 * Для анализа цены берутся +-TABLE_RANGE_DATES дня по диагонали в таблице.
 */
export default function getPriceHintTypeForDayOfDynamicTable({
    prices,
    dateForward,
    dateBackward,
    datesForward,
    datesBackward,
}: IGetPriceHintTypeForDayOfDynamicTable): EPriceHintType {
    const priceDay = getPriceForDay(
        dateForward.date,
        dateBackward.date,
        prices,
    );
    const priceDays: IPriceDay[] = [priceDay];

    let leftRange = TABLE_RANGE_DATES;
    let rightRange = TABLE_RANGE_DATES;

    let forwardIndex = dateForward.index - 1;
    let backwardIndex = dateBackward.index - 1;

    // Сначала пойдем в левый верхний угол таблицы
    while (leftRange > 0) {
        if (forwardIndex < 0 || backwardIndex < 0) {
            rightRange += leftRange;
            leftRange = 0;

            break;
        }

        priceDays.push(
            getPriceForDay(
                datesForward[forwardIndex].date,
                datesBackward[backwardIndex].date,
                prices,
            ),
        );

        forwardIndex--;
        backwardIndex--;
        leftRange--;
    }

    // А сейчас в правый нижний угол
    forwardIndex = dateForward.index + 1;
    backwardIndex = dateBackward.index + 1;

    while (rightRange > 0) {
        if (
            forwardIndex > datesForward.length - 1 ||
            backwardIndex > datesBackward.length - 1
        ) {
            break;
        }

        priceDays.push(
            getPriceForDay(
                datesForward[forwardIndex].date,
                datesBackward[backwardIndex].date,
                prices,
            ),
        );

        forwardIndex++;
        backwardIndex++;
        rightRange--;
    }

    return getDynamicsCalendarDayType(priceDay, priceDays);
}

function getPriceForDay(
    dateForward: TDateRobot,
    dateBackward: TDateRobot,
    prices: TDynamicTableDaysInfo,
): IPriceDay {
    const key = getKeyForTablePrice(dateForward, dateBackward);

    return {price: prices[key]?.price || null};
}
