import {IDynamicsDay} from 'projects/avia/components/Dynamics/types/IDynamicsDay';

import {IAviaContext} from 'reducers/avia/data-types';

/**
 * Функция проверяет совпадает ли день (на самом деле два дня) в авиа динамике
 * с днями в поисковом контексте (выдача)
 */
function isCurrentDynamicDay(
    context: IAviaContext,
    item: IDynamicsDay,
): boolean {
    const isSameForwardDate = context.when === item.dateForward.date;
    const isSameReturnDate =
        context.return_date && item.dateBackward?.date
            ? context.return_date === item.dateBackward?.date
            : true;

    return isSameForwardDate && isSameReturnDate;
}

export default isCurrentDynamicDay;
