import {ECompareResult} from 'projects/avia/lib/comparators/TComparator';
import {PriceComparator} from 'utilities/currency/compare';

import {IDayWithPrice} from './getPriceHintInfo';

export function sortDynamicsPrices(
    a: IDayWithPrice,
    b: IDayWithPrice,
    priceComparator: PriceComparator,
) {
    if (a.price && b.price) {
        if (a.price.roughly || b.price.roughly) {
            return a.price.roughly ? ECompareResult.GT : ECompareResult.LT;
        }

        return priceComparator.compare(a.price, b.price);
    }

    if (a.price) {
        return a.price.roughly ? ECompareResult.GT : ECompareResult.LT;
    }

    return ECompareResult.GT;
}
