import React from 'react';

import {TermAvailability} from 'server/api/AviaBookingApi/types/TermAvailability';

import IPrice from 'utilities/currency/PriceInterface';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Price from 'components/Price/Price';
import CheckCircleIcon from 'icons/16/CheckCircle';
import CloseCircleIcon from 'icons/16/CloseCircle';
import RoubleS from 'icons/illustrations/Rouble/RoubleS';

import cx from './FlightFareAvailabilityTerm.scss';

interface IFlightFareAvailabilityTermProps extends IWithQaAttributes {
    availability: TermAvailability;
    charge?: IPrice;
}

const ICON_SIZES = {width: 20, height: 20};

export const FlightFareAvailabilityTerm: React.FC<IFlightFareAvailabilityTermProps> =
    props => {
        const {availability, charge} = props;

        if (availability === TermAvailability.CHARGE) {
            return charge ? (
                <Price
                    withConversion={false}
                    {...charge}
                    {...prepareQaAttributes({parent: props, current: 'price'})}
                />
            ) : (
                <RoubleS
                    {...ICON_SIZES}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'chargeIcon',
                    })}
                />
            );
        }

        if (availability === TermAvailability.FREE) {
            return (
                <CheckCircleIcon
                    className={cx('availableIcon')}
                    fill="currentColor"
                    {...ICON_SIZES}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'availableIcon',
                    })}
                />
            );
        }

        if (availability === TermAvailability.NOT_AVAILABLE) {
            return (
                <CloseCircleIcon
                    className={cx('notAvailableIcon')}
                    {...ICON_SIZES}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'notAvailableIcon',
                    })}
                />
            );
        }

        return null;
    };
