import React from 'react';

import {
    formatBaggage,
    formatBaggageCompact,
} from 'projects/avia/lib/flightFareTerms/formatters';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

interface IFlightFareBaggageTermProps extends IWithQaAttributes {
    places?: number;
    weight?: number;
    compact?: boolean;
}

export const FlightFareBaggageTerm: React.FC<IFlightFareBaggageTermProps> =
    props => {
        const {places, weight, compact} = props;

        return (
            <span {...prepareQaAttributes(props)}>
                {compact
                    ? formatBaggageCompact({places, weight})
                    : formatBaggage({places, weight})}
            </span>
        );
    };
