import {FC, useMemo} from 'react';

import {IFFMilesTermRule} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';
import {IWithClassName} from 'types/withClassName';

import {TermsHelper} from 'projects/avia/pages/AviaOrder/components/FlightInfoFareFamily/utils/TermsHelper';

import * as i18nBlock from 'i18n/avia-search-tariffs';

import IncludedIcon from 'icons/24/Included';
import NotIncludedIcon from 'icons/24/NotIncluded';
import Text from 'components/Text/Text';

import cx from './MilesInfo.scss';

export interface IMilesInfoProps extends IWithClassName {
    milesTerm?: IFFMilesTermRule;
}

const MilesInfo: FC<IMilesInfoProps> = ({milesTerm, className}) => {
    const miles = TermsHelper.getMiles(milesTerm);
    const hasMiles = miles !== null && miles > 0;

    const IconLeft = useMemo(() => {
        return hasMiles ? IncludedIcon : NotIncludedIcon;
    }, [hasMiles]);

    const text = useMemo(() => {
        return hasMiles
            ? i18nBlock.includedMiles({miles})
            : i18nBlock.withoutMiles();
    }, [hasMiles, miles]);

    if (miles === null) {
        return null;
    }

    return (
        <span className={cx('content', className)}>
            <IconLeft
                className={cx('icon', {
                    icon_included: hasMiles,
                })}
            />
            <Text
                size="m"
                className={cx('text', {
                    text_included: hasMiles,
                })}
            >
                {text}
            </Text>
        </span>
    );
};

export default MilesInfo;
