import React from 'react';
import {RouteComponentProps, withRouter} from 'react-router-dom';
import {parse} from 'query-string';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

import * as keyset from 'i18n/avia-ModalMapNearAirports';

import Modal from 'components/Modal/Modal';
import MapNearAirports from 'projects/avia/components/MapNearAirports/MapNearAirports';

import cx from './ModalMapNearAirports.scss';

interface IModalMapNearAirportsProps extends RouteComponentProps {
    isVisible: boolean;
    onClose: () => void;
}

const ModalMapNearAirports: React.FC<IModalMapNearAirportsProps> = ({
    isVisible,
    onClose,
    location,
}) => {
    return (
        <Modal isVisible={isVisible} onClose={onClose} className={cx('map')}>
            {isVisible && (
                <div className={cx('container')}>
                    <div className={cx('title-container')}>
                        <h1 className={cx('title-text')}>
                            {keyset.nearestDashAirports()}
                        </h1>
                    </div>
                    <MapNearAirports
                        formParams={
                            parse(location.search) as unknown as IAviaParams
                        }
                        key={location.search}
                    />
                </div>
            )}
        </Modal>
    );
};

export default withRouter(ModalMapNearAirports);
