import {useCallback} from 'react';
import {useHistory} from 'react-router-dom';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {useCoordinator} from 'contexts/PlatformContext';

import cx from './NativeAppBackButton.scss';

export const NativeAppBackButton = () => {
    const history = useHistory();
    const coordiantor = useCoordinator();

    const clickHandler = useCallback(() => {
        if (!coordiantor.doAction(EAppActions.SHOW_SEARCH_FORM, {})) {
            history.goBack();
        }
    }, [history, coordiantor]);

    return (
        <button className={cx('button')} type="button" onClick={clickHandler} />
    );
};
