import React from 'react';
import LogoMonochrome from 'src/svg/illustrations/Logo/LogoMonochrome.svg';

import {ITDPartner} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/avia-AviaResultVariant';

import {IPartnerInfo} from 'server/api/AviaPartnersApi/AviaPartnersApi';

import cx from './PartnerLogo.scss';

interface IAviaPartnerLogoProps extends IWithQaAttributes {
    className?: string;
    partner: ITDPartner | IPartnerInfo | null;
    size: 's' | 'm';
    isBoy?: boolean;
}

const AviaPartnerLogo: React.FC<IAviaPartnerLogoProps> = props => {
    const {className, partner, size = 's', isBoy} = props;

    if (!partner) {
        throw new Error('[AVIA] Empty partner in AviaPartnerLogo');
    }

    const title = isBoy ? i18nBlock.boyTitle() : partner.title;
    const logoSvg = isBoy ? LogoMonochrome : partner.logoSvg || undefined;

    return (
        <div
            className={cx('root', className, `root_size_${size}`)}
            {...prepareQaAttributes(props)}
        >
            <div className={cx('root__container')}>
                {partner.logoSvg && (
                    <div
                        className={cx('root__image-container')}
                        style={{backgroundImage: `url(${logoSvg})`}}
                    >
                        <img
                            src={logoSvg}
                            className={cx('root__image')}
                            alt="partner logo"
                            {...prepareQaAttributes({
                                parent: props,
                                current: 'img',
                            })}
                        />
                    </div>
                )}
                <div className={cx('root__alt')}>{title}</div>
            </div>
        </div>
    );
};

export default AviaPartnerLogo;
