import React, {useRef} from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';
import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {deviceModMobile} from 'utilities/stylesUtils';

import * as i18nBlockAviaPlus from 'i18n/avia-plusPromo2021';

import Text, {TTextSize} from 'components/Text/Text';
import {EMessageBoxPopupTheme} from 'components/MessageBoxPopup/MessageBoxPopup';
import Heading from 'components/Heading/Heading';
import MessageBoxPopupOrBottomSheet from 'components/MessageBoxPopupOrBottomSheet/MessageBoxPopupOrBottomSheet';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';

import cx from './PlusInfo.scss';

interface IPlusInfoProps extends IWithDeviceType, IWithClassName {
    plusPoints: number;
    textSize?: TTextSize;
    popupText: string;
    tankerTranslation: (params: {
        count: string | number | boolean;
        element: string | number | boolean;
    }) => string;
}

const PlusInfo: React.FC<IPlusInfoProps> = ({
    plusPoints,
    deviceType,
    tankerTranslation,
    textSize = 'm',
    className,
    popupText,
}) => {
    const {
        value: isTooltipVisible,
        setTrue: showTooltip,
        setFalse: hideTooltip,
    } = useBoolean(false);

    const contentRef = useRef<HTMLDivElement | null>(null);

    return (
        <div className={cx('root', className)}>
            <YandexPlusSignColorGradientS className={cx('plusIcon')} />
            <Text size={textSize}>
                {insertJSXIntoKey(tankerTranslation)({
                    count: plusPoints,
                    element: (
                        <Text
                            size={textSize}
                            color="link"
                            onClick={showTooltip}
                            tagProps={{ref: contentRef}}
                        >
                            {i18nBlockAviaPlus.plusText()}
                        </Text>
                    ),
                })}
            </Text>
            <MessageBoxPopupOrBottomSheet
                isVisible={isTooltipVisible}
                onClose={hideTooltip}
                messageBoxProps={{
                    anchorRef: contentRef,
                    theme: EMessageBoxPopupTheme.WHITE,
                    direction: EPopupDirection.BOTTOM_RIGHT,
                }}
            >
                <div
                    className={cx(
                        'popupContainer',
                        deviceModMobile('popupContainer', deviceType),
                    )}
                >
                    <Heading level="3">{i18nBlockAviaPlus.plusTitle()}</Heading>
                    <Text tag="div" className={cx('popupContainer_text')}>
                        {popupText}
                    </Text>
                    {/* ToDo: Во время проекта как придет решение - сразу разкомментим,
                     сделал, чтоб минимальное количество вреемени на это потратитьы
                     <Link
                        to="https://yandex.ru"
                        className={cx('popupContainer_link')}
                    >
                        {i18nBlockAviaPlus.plusPopupMoreInfo()}
                    </Link> */}
                </div>
            </MessageBoxPopupOrBottomSheet>
        </div>
    );
};

export default React.memo(PlusInfo);
