import React, {SyntheticEvent, useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {IWithClassName} from 'types/withClassName';
import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {reachGoal} from 'utilities/metrika';

import Link, {TLinkThemeType} from 'components/Link/Link';

import {useGetRedirectUrl} from 'projects/avia/hooks/useGetRedirectUrl';

import {INotifierBuyTickets, useCoordinator} from 'contexts/PlatformContext';

interface IRedirectLink extends IWithClassName {
    variant: IResultAviaVariant;
    goal?: EAviaGoal.ORDER_REDIRECT | EAviaGoal.SEARCH_REDIRECT;
    style?: React.CSSProperties;
    theme?: TLinkThemeType;
}

const RedirectLink: React.FC<IRedirectLink> = ({
    className,
    variant,
    goal = EAviaGoal.SEARCH_REDIRECT,
    style,
    theme,
    children,
}) => {
    const coordinator = useCoordinator();
    const getRedirectUrl = useGetRedirectUrl();
    const redirectUrl = getRedirectUrl(variant);

    const handleClick = useCallback(
        (e: SyntheticEvent) => {
            if (coordinator.canProcess(EAppActions.BUY_TICKETS)) {
                coordinator.doAction<INotifierBuyTickets>(
                    EAppActions.BUY_TICKETS,
                    {
                        offer: variant,
                        redirectUrl,
                    },
                );
                e.preventDefault();
            }

            reachGoal(goal);
        },
        [coordinator, goal, variant, redirectUrl],
    );

    return (
        <Link
            className={className}
            onClick={handleClick}
            url={redirectUrl}
            target="_blank"
            style={style}
            theme={theme}
        >
            {children}
        </Link>
    );
};

export default RedirectLink;
