import {FC, memo, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {
    IFFRefundableTermRule,
    EFareFamilyAvailability,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

import {getRefundText} from 'projects/avia/components/RefundInfo/utilities/getRefundText';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import IncludedIcon from 'icons/24/Included';
import PaidReturnIcon from 'icons/24/PaidReturn';
import NotIncludedIcon from 'icons/24/NotIncluded';
import Text from 'components/Text/Text';

import cx from './ExpandedRefundInfo.scss';

export interface IRefundIconWithInfoProps
    extends IWithClassName,
        IWithQaAttributes {
    refund: IFFRefundableTermRule | null;
}

const ExpandedRefundInfo: FC<IRefundIconWithInfoProps> = props => {
    const {className, refund} = props;

    const type = refund?.availability ?? null;

    const text = getRefundText(refund);

    const IconLeft = useMemo(() => {
        if (type === EFareFamilyAvailability.free) {
            return IncludedIcon;
        }

        if (type === EFareFamilyAvailability.charge) {
            return PaidReturnIcon;
        }

        return NotIncludedIcon;
    }, [type]);

    return (
        <span
            className={cx('content', className)}
            {...prepareQaAttributes({parent: props, current: 'refundInfo'})}
        >
            <IconLeft
                className={cx('icon', {
                    icon_included: type === EFareFamilyAvailability.free,
                })}
                {...prepareQaAttributes({parent: props, current: 'refundIcon'})}
            />
            <Text
                size="m"
                className={cx('text', {
                    text_included: type === EFareFamilyAvailability.free,
                })}
                {...prepareQaAttributes({parent: props, current: 'refundText'})}
            >
                {text}
            </Text>
        </span>
    );
};

export default memo(ExpandedRefundInfo);
