import React, {FC} from 'react';

import {IWithClassName} from 'types/withClassName';
import {
    IFFRefundableTermRule,
    EFareFamilyAvailability,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

import {getShortRefundText} from 'projects/avia/components/RefundInfo/utilities/getRefundText';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import NoTicketReturnIcon from 'icons/24/NoTicketReturn';
import TicketReturnIcon from 'icons/24/TicketReturn';
import PaidReturnIcon from 'icons/16/PaidReturn';
import TextWithIcon, {TSize} from 'components/TextWithIcon/TextWithIcon';

import cx from './ShortRefundInfo.scss';

export interface IRefundIconWithInfoProps
    extends IWithClassName,
        IWithQaAttributes {
    refund: IFFRefundableTermRule | null;
    showCurrency?: boolean;
    textSize?: TSize;
}

const ShortRefundInfo: FC<IRefundIconWithInfoProps> = ({
    className,
    refund,
    showCurrency,
    textSize = 's',
    ...rest
}) => {
    const deviceType = useDeviceType();

    const type = refund?.availability ?? null;

    const text = deviceType.isDesktop ? getShortRefundText() : null;

    const IconLeft =
        type === EFareFamilyAvailability.free ||
        type === EFareFamilyAvailability.charge
            ? TicketReturnIcon
            : NoTicketReturnIcon;

    return (
        <span
            className={cx('content', className)}
            {...prepareQaAttributes(rest)}
        >
            <IconLeft
                className={cx({
                    icon_included: type === EFareFamilyAvailability.free,
                })}
            />
            <TextWithIcon
                className={cx('textWithCurrency')}
                size={textSize}
                text={text}
                textClassName={cx('text', {
                    text_included: type === EFareFamilyAvailability.free,
                })}
                iconRightClassName={cx('currencyIcon')}
                iconRight={
                    showCurrency && type === EFareFamilyAvailability.charge
                        ? PaidReturnIcon
                        : undefined
                }
            />
        </span>
    );
};

export default React.memo(ShortRefundInfo);
