import {ReactNode} from 'react';

import {
    EFareFamilyAvailability,
    IFFRefundableTermRule,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {isDeprecatedPrice} from 'utilities/currency/IDeprecatedPrice';

import * as i18nBlock from 'i18n/avia-search-tariffs';

import Price from 'components/Price/Price';

const REFUND_TEXT_MAP = {
    [EFareFamilyAvailability.notAvailable]: i18nBlock.withoutRefund(),
    [EFareFamilyAvailability.charge]: i18nBlock.chargedRefund(),
    [EFareFamilyAvailability.free]: i18nBlock.includedRefund(),
};

export function getRefundText(refund: IFFRefundableTermRule | null): ReactNode {
    if (!refund || !refund.availability) {
        return i18nBlock.withoutInfoRefund();
    }

    const refundPrice = refund.charge;

    if (isDeprecatedPrice(refundPrice)) {
        return insertJSXIntoKey(i18nBlock.chargedRefundWithPrice)({
            price: <Price withConversion={false} {...refundPrice} />,
        });
    }

    return REFUND_TEXT_MAP[refund.availability];
}

export function getShortRefundText(): ReactNode {
    return i18nBlock.refund();
}
