import {ESearchFormFieldName} from 'components/SearchForm/types';
import {EAviaClassType} from 'types/avia/EAviaClassType';
import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';

import {ISuggestValue} from 'components/SearchSuggest/SearchSuggest';

export interface IAviaSearchFormPointField
    extends ISuggestValue<IAviaSuggest> {}

export type TAviaSearchFormDateField = string | null;

export interface IAviaSearchFormValues {
    [ESearchFormFieldName.FROM]: IAviaSearchFormPointField;
    [ESearchFormFieldName.TO]: IAviaSearchFormPointField;
    [ESearchFormFieldName.START_DATE]: TAviaSearchFormDateField;
    [ESearchFormFieldName.END_DATE]: TAviaSearchFormDateField;
    isRoundTrip: boolean;
    adults: number;
    children: number;
    infants: number;
    aviaClass: EAviaClassType;
}

export interface IAviaSearchFormErrors {
    [ESearchFormFieldName.FROM]?: string[];
    [ESearchFormFieldName.TO]?: string[];
    [ESearchFormFieldName.START_DATE]?: string[];
    [ESearchFormFieldName.END_DATE]?: string[];
}
