import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';
import {EAviaSuggestsApiItemType} from 'server/api/AviaSuggestsApi/types/TAviaGetSuggestsApiResponse';

import {CHAR_MIDDLE_DOT} from 'utilities/strings/charCodes';

export default function getSuggestTitleAndDescription(item: IAviaSuggest): {
    title: string;
    description: string;
} {
    const {
        title,
        pointCode,
        regionTitle,
        countryTitle,
        isUniqueTitle,
        specialDescription,
        type,
    } = item;

    if (type === EAviaSuggestsApiItemType.SPECIAL && specialDescription) {
        return {
            title,
            description: specialDescription,
        };
    }

    const preparedRegionTitle =
        regionTitle && !isUniqueTitle ? `${regionTitle}, ` : '';

    return {
        title,
        description: `${
            pointCode ? `${pointCode} ${CHAR_MIDDLE_DOT} ` : ' '
        }${preparedRegionTitle}${countryTitle}`,
    };
}
