import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';
import IPersonalizedAviaItem from 'server/api/PersonalizationApi/types/IPersonalizedAviaItem';

import formatSearchHistoryItemsToSearchFormItem from 'projects/index/IndexApp/utilities/formatSearchHistoryItemsToSearchFormItem';

interface IMappedResults {
    [ESearchFormFieldName.FROM]: IAviaSuggest[];
    [ESearchFormFieldName.TO]: IAviaSuggest[];
}

export default function mapPreviousSearches(
    previousSearches: IPersonalizedAviaItem[],
): IMappedResults {
    return {
        [ESearchFormFieldName.FROM]: previousSearches.map(item => ({
            ...item.from,
            ...getBaseSuggest(item),
        })),
        [ESearchFormFieldName.TO]: previousSearches.map(item => ({
            ...item.to,
            ...getBaseSuggest(item),
        })),
    };
}

interface IBaseSuggest
    extends Pick<
        IAviaSuggest,
        'pointKey' | 'previousSearch' | 'isUniqueTitle' | 'isPreviousSearch'
    > {}

function getBaseSuggest(item: IPersonalizedAviaItem): IBaseSuggest {
    return {
        pointKey: getItemPointKey(item),
        previousSearch: formatSearchHistoryItemsToSearchFormItem(item),
        isUniqueTitle: false,
        isPreviousSearch: true,
    };
}

function getItemPointKey(item: IPersonalizedAviaItem): string {
    return `${item.from.pointKey}_${item.to.pointKey}`;
}
