import React from 'react';

import {TSettlementKey, TStationKey} from 'types/PointKey';
import TDateRobot from 'types/common/date/TDateRobot';
import {IPassengers} from 'projects/avia/pages/AviaBooking/types/IPassengers';
import {EAviaClassType} from 'types/avia/EAviaClassType';
import {IWithClassName} from 'types/withClassName';
import {EAviaLinkSource} from 'types/avia/url/EAviaLinkSource';

import {getSearchUrl} from 'projects/avia/lib/urls/getSearchUrl';

import Link from 'components/Link/Link';

import Settlement, {ISettlement} from './Settlement';

export interface ISettlementLink extends ISettlement, IWithClassName {
    /**
     * Ключ города/станции отправления
     * @example 'c54'
     */
    fromPointKey: TSettlementKey | TStationKey;
    /** Дата "туда" */
    dateForward: TDateRobot;
    /** Количество пассажиров */
    passengers: IPassengers;
    /** Класс обслуживания */
    klass: EAviaClassType;
    /** Дата "обратно" */
    dateBackward: TDateRobot | undefined;
    /** Источник перехода для ссылок на поиск (пишется в логи) */
    linkSource: EAviaLinkSource;
}

/**
 * Компонент отображения города для страницы поиска в страну и "куда угодно".
 * Используется как в десктопной, так и в мобильной версии.
 */
const SettlementLink: React.FC<ISettlementLink> = ({
    cityKey,
    title,
    images,
    minWidth,
    price,
    inlineSearchDataForCitySelector,
    size,
    fromPointKey,
    dateForward,
    passengers,
    klass,
    dateBackward,
    linkSource,
    className,
}) => {
    const searchUrl = getSearchUrl({
        passengers,
        fromKey: fromPointKey,
        toKey: cityKey,
        klass,
        dateForward,
        dateBackward,
        filters: undefined,
        linkSource,
    });

    return (
        <Link to={searchUrl} theme="black">
            <Settlement
                cityKey={cityKey}
                size={size}
                title={title}
                images={images}
                minWidth={minWidth}
                price={price}
                inlineSearchDataForCitySelector={
                    inlineSearchDataForCitySelector
                }
                className={className}
            />
        </Link>
    );
};

export default React.memo(SettlementLink);
