import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './SettlementSkeleton.scss';

const SettlementSkeleton: React.FC = () => {
    const {isDesktop} = useDeviceType();

    return (
        <div className={cx('root', {isDesktop})}>
            <Skeleton className={cx('imageSkeleton')} withAnimation={true} />
            <TextSkeleton
                className={cx('titleSkeleton')}
                size={isDesktop ? 'l' : 'm'}
                withAnimation={true}
            />
            <TextSkeleton
                className={cx('priceSkeleton')}
                size={isDesktop ? 'l' : 's'}
                withAnimation={true}
            />
        </div>
    );
};

export default React.memo(SettlementSkeleton);
