import {Component, ReactNode} from 'react';

interface ITrackChangeProps<T> {
    value: T;

    onChange(value: T): any;

    areValuesEqual(a: T, b: T): boolean;
}

/**
 * Компонента вызывает колбек `onChange` при изменении пропса `value`
 */
export class TrackChange<Value> extends Component<ITrackChangeProps<Value>> {
    static defaultProps = {
        areValuesEqual(a: any, b: any) {
            return a === b;
        },
    };

    componentDidMount(): void {
        this.props.onChange(this.props.value);
    }

    componentDidUpdate({value: oldValue}: ITrackChangeProps<Value>): void {
        if (oldValue !== this.props.value) {
            this.props.onChange(this.props.value);
        }
    }

    render(): ReactNode {
        return null;
    }
}
