import React, {useCallback} from 'react';
import {useSelector} from 'react-redux';

import {MINUTE} from 'utilities/dateUtils/constants';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {getAviaContext} from 'selectors/avia/aviaSelectors';

import {reachGoal} from 'utilities/metrika';
import {formatPeriod} from 'utilities/dateUtils/formatPeriod';

import * as i18nBlock from 'i18n/avia-UpdateNotification';

import BaseUpdateNotification from 'components/UpdateNotification/UpdateNotification';

interface IUpdateNotificationProps {
    forceHide: boolean;
}

export const UpdateNotification: React.FC<IUpdateNotificationProps> = ({
    forceHide,
}) => {
    const {
        toName,
        fromName,
        when,
        /* eslint-disable-next-line camelcase */
        return_date,
    } = useSelector(getAviaContext);

    const handleShowNotification = useCallback(() => {
        reachGoal(EAviaGoal.SEARCH_OUTDATE);
    }, []);

    const handleUpdate = useCallback(() => {
        reachGoal(EAviaGoal.SEARCH_OUTDATE_REFRESH);
    }, []);

    const handleSkip = useCallback(() => {
        reachGoal(EAviaGoal.SEARCH_OUTDATE_CONTINUE);
    }, []);

    return (
        <BaseUpdateNotification
            text={i18nBlock.text({
                fromName,
                toName,
                period: formatPeriod(when, return_date),
            })}
            timeout={30 * MINUTE}
            onShowNotification={handleShowNotification}
            onUpdate={handleUpdate}
            onSkip={handleSkip}
            forceHide={forceHide}
        />
    );
};
