import React from 'react';

import {IVariantForFlightTariff} from './types/tariffTypes';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {collectFlightTariffsFromVariants} from './utilities/collectFlightTariffsFromVariants';

import {VariantsTariffTableDesktop} from './components/VariantsTariffTableDesktop/VariantsTariffTableDesktop';
import {VariantsTariffTableMobile} from './components/VariantsTariffTableMobile/VariantsTariffTableMobile';

export interface IVariantsTariffTableProps extends IWithQaAttributes {
    variants: IVariantForFlightTariff[];
    variantToken?: string;
    onChange?(token: string): void;
}

export const VariantsTariffTable: React.FC<IVariantsTariffTableProps> =
    props => {
        const {variants, variantToken, onChange} = props;

        const deviceType = useDeviceType();

        const flightTariffs = React.useMemo(
            () => collectFlightTariffsFromVariants(variants),
            [variants],
        );

        const activeColumn =
            variantToken === undefined
                ? -1
                : variants.findIndex(variant => variant.id === variantToken);

        const Table = deviceType.isMobile
            ? VariantsTariffTableMobile
            : VariantsTariffTableDesktop;

        return (
            <Table
                onChange={onChange}
                flightTariffs={flightTariffs}
                activeColumn={activeColumn}
                {...prepareQaAttributes(props)}
            />
        );
    };
