import {TUserSettlement} from 'types/avia/TUserSettlement';
import {TAnywherePointKey} from 'types/avia/TAnywherePointKey';

export const USER_SETTLEMENT: TUserSettlement = '-me';

// pointKey для поиска "куда угодно"
export const ANYWHERE_POINT_KEY: TAnywherePointKey = 'anywhere';

/**
 * Высота изображения в пикселях для компонента с населенным пунктом на странице
 * поиска в страну и "куда угодно".
 * Используется для оптимального подбора размера изображения как для обычных, так и для ретина-экранов.
 * Так же эти переменные используются в css (src/projects/avia/styles/searchToLandings.scss)
 */
export const HEIGHT_IMAGES = {
    s: 143,
    m: 227,
} as const;

export const TITLE_COUNTRY_RUSSIA = 'Россия';

export enum EColors {
    BLACK = '#000',
    GRAY = '#808080',
}
